<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
<meta charset="UTF-8">
<meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
<title>{$site_name}  {$site_description}</title>
<link rel="shortcut icon" href="{$site_logo}" type="image/x-icon">
<link rel="icon" href="{$site_logo}" type="image/x-icon">

<link rel="stylesheet" href="/dist/modules/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<link rel="stylesheet" href="/dist/modules/bootstrap-social/bootstrap-social.css">
<link href="https://cdn.datatables.net/v/bs4/dt-1.13.6/b-2.4.2/r-2.5.0/sr-1.3.0/datatables.min.css" rel="stylesheet">

<link rel="stylesheet" href="/dist/modules/select2.min.css">
<link rel="stylesheet" href="/dist/modules/summernote/summernote-bs4.css">
<link rel="stylesheet" href="/dist/sweetalert2/sweetalert2.min.css">
<link rel="stylesheet" href="/dist/css-{$site_theme}/style.css">
<link rel="stylesheet" href="/dist/css-{$site_theme}/components.css">
{include file='css/custom_css.tpl'}
</head>
<body>

<div class="center" id="loading">
    <div class='building-blocks'>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
    </div>
</div>

<div class="main-wrapper">

{include file='apps/topnav.tpl'}
{include file='apps/sidenav.tpl'}


<div class="main-content">
<section class="section">
<div class="section-header">
<h1>Dashboard</h1>
</div>
<div class="section-body">
{$mainte}
{if $user_id_2=='1' || $user_level_2=='superadmin' || $user_level_2=='developer' }  


<!--div class="fetch-update alert alert-primary alert-dismissible fade">
<div class="alert-body">
<button class="close" data-dismiss="alert">
<span>&times;</span>
</button>
<i class="fas fa-star-half-alt"></i> What's new on version <code><span class="panel-version"></span></code> :
<ul class="panel-update-list"></ul>
</div>
</div-->
{/if}
{if $user_level_2=='reseller' }

<div class="hero text-white hero-bg-image hero-bg-parallax" style="background-image: url('dist/img/bg.jpg');">
<div class="hero-inner">
<h2>Welcome, {$user_name_2}!</h2>
<p class="lead">Thank you for choosing {$site_name} as your vpn service provider. We will keep you up to date.</p>
<div class="mt-4">
<a href="add-user" class="btn btn-outline-white btn-lg btn-icon icon-left"><i class="far fa-user"></i> Create Account</a>
</div>
</div>
</div>
<br>
{/if}

</div>

<div class="row">

{if $user_id_2=='1' || $user_level_2=='superadmin' || $user_level_2=='developer' || $user_level_2 == 'reseller' }
<div class="col-lg-3 col-md-6 col-sm-6">
    <div class="card card-statistic-2 card-primary">
        <div class="card-icon shadow-primary bg-primary">
            <i class="fas fa-user-tie"></i>
        </div>
        <div class="card-wrap">
            <div class="card-header">
                <h4>Reseller</h4>
            </div>
        <div class="card-body stats-reseller"></div>
        </div>
    </div>
</div>

<div class="col-lg-3 col-md-6 col-sm-6">
    <div class="card card-statistic-2 card-primary">
        <div class="card-icon shadow-primary bg-primary">
            <i class="fas fa-users"></i>
        </div>
        <div class="card-wrap">
            <div class="card-header">
                <h4>Users</h4>
            </div>
            <div class="card-body stats-user"></div>
        </div>
    </div>
</div>

<div class="col-lg-3 col-md-6 col-sm-6">
    <div class="card card-statistic-2 card-primary">
        <div class="card-icon shadow-primary bg-primary">
            <i class="fas fa-signal"></i>
        </div>
        <div class="card-wrap">
            <div class="card-header">
                <h4>Online</h4>
            </div>
            <div class="card-body stats-online"></div>
        </div>
    </div>
</div>

{if $user_id_2=='1' || $user_level_2=='superadmin' || $user_level_2=='developer' || $user_level_2=='reseller'}

<div class="col-lg-3 col-md-6 col-sm-6">
    <div class="card card-statistic-2 card-primary">
        <div class="card-icon shadow-primary bg-primary">
            <i class="fas fa-server"></i>
        </div>
        <div class="card-wrap">
            <div class="card-header">
                <h4>Servers</h4>
            </div>
            <div class="card-body stats-server"></div>
        </div>
    </div>
</div>
{/if}


{if $user_id_2=='1' || $user_level_2=='superadmin' || $user_level_2=='developer'}
</div>

<div class="row">
    <div class="col-lg-4 col-md-6 col-sm-6 d-flex">
        <div class="card card-primary flex-fill">
            <div class="card-header">
                <h4>TOP 5 SALES RESELLERS</h4>
            </div>
            <div class="card-body">
            <table class="table table-striped table-sm top-reseller">
            <thead>
            </thead>
            <tbody>
            </tbody>
            </table>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-sm-6 d-flex">
        <div class="card card-primary flex-fill">
            <div class="card-header">
                <h4>TOP 5 BANDWIDTH USERS</h4>
            </div>
            <div class="card-body">
            <table class="table table-striped table-sm top-user">
            <thead>
            </thead>
            <tbody>
            </tbody>
            </table>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-sm-6 d-flex">
        <div class="card card-primary flex-fill">
            <div class="card-header">
                <h4>TOP 5 BANDWIDTH SERVERS</h4>
            </div>
            <div class="card-body">
            <table class="table table-striped table-sm top-server">
            <thead>
            </thead>
            <tbody>
            </tbody>
            </table>
            </div>
        </div>
    </div>
</div>
 
<div class="row">

{/if}

    
</div>

<div class="row">
    
<!--div class="col-lg-3 col-md-6 col-sm-6">
    <div class="card card-primary">
    <div class="card-header">
    <h4>Profile</h4>
    </div>
    <div class="card-body">
    <ul class="list-unstyled user-progress list-unstyled-border list-unstyled-noborder">
    <li class="media">
    {$avatar2}
    <div class="media-body">
    <div class="media-title text-uppercase profile-username"></div>
    <div class="text-job text-muted">Username</div>
    </div>
    </li>
    <li class="media">
    {$avatar6}
    <div class="media-body">
    <div class="media-title text-uppercase profile-upline"></div>
    <div class="text-job text-muted">Upline</div>
    </div>
    </li>
    <li class="media">
    <img alt="image" class="mr-3 rounded-circle" width="50" src="/dist/img/dashboard/credits.png">
    <div class="media-body">
    <div class="media-title text-uppercase profile-credits"></div>
    <div class="text-job text-muted">Credits</div>
    </div>
    </li>
    </ul>
    </div>
    </div>
</div>

<div class="col-lg-3 col-md-6 col-sm-6">
    <div class="card card-primary">
    <div class="card-header">
    <h4>Users</h4>
    </div>
    <div class="card-body">
    <canvas id="userchart"></canvas>
    </div>
    </div>
</div>

<div class="col-lg-6 col-md-6 col-sm-6">
        <div class="card card-primary">
            <div class="card-header">
            <h2 class="section-title">Recent Activities</h2>
            </div>
            <div class="card-body">
<table class="table table-sm table-activity">
<thead>
<tr>
    <th scope="col">Time</th>
    <th scope="col">Device</th>
    <th scope="col">Action</th>
</tr>
</thead>
<tbody>
</tbody>
</table>
</div>
<div class="card-body">             
                <ul class="list-unstyled list-unstyled-border stats-activity">
                
                </ul>
                <div class="text-center pt-1 pb-1">
                    <a href="log-activity" class="btn btn-primary">
                        View All
                    </a>
                </div>
            </div>
        </div>
    </div-->
</div>
{/if}
</div>
</section>
</div>

<div class="modal fade modalize" role="dialog" aria-labelledby="smallmodal">
<div class="modal-dialog modal-md" role="document">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title"></h5>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body">
<div class="modal-error"></div>
<div class="modal-html"></div>
</div>
</div>
</div>
</div>

<div class="modal fade search-modalize" role="dialog" aria-labelledby="smallmodal">
<div class="modal-dialog modal-md search-modal-dialog" role="document">
<div class="modal-content search-modal-content">
<div class="modal-header search-modal-header">
<h5 class="modal-title search-modal-title"></h5>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body search-modal-body">
<div class="modal-error search-modal-error"></div>
<div class="modal-html search-modal-html"></div>
</div>
</div>
</div>
</div>

<script src="/dist/modules/jquery.min.js"></script>
<script src="/dist/modules/popper.js"></script>
<script src="/dist/modules/tooltip.js"></script>
<script src="/dist/modules/bootstrap/js/bootstrap.min.js"></script>
<script src="/dist/modules/nicescroll/jquery.nicescroll.min.js"></script>
<script src="/dist/modules/moment.min.js"></script>
<script src="/dist/sweetalert2/sweetalert2.min.js"></script>
<script src="/dist/modules/time.js"></script>
<script src="/dist/js/stisla.js"></script>

<script src="/dist/modules/chart.min.js"></script>
<script src="https://cdn.datatables.net/v/bs4/dt-1.13.6/b-2.4.2/r-2.5.0/sl-1.7.0/datatables.min.js"></script>
<script src="/dist/modules/select2/dist/js/select2.full.min.js"></script>
<script src="/dist/modules/jquery-ui/jquery-ui.min.js"></script>
<script src="/dist/bootstrap/assets/jqueryform/jquery.form.js"></script>
<script src="/dist/modules/summernote/summernote-bs4.min.js"></script>
<script src="/dist/modules/select2.full.min.js"></script>

<script src="/dist/js/clipboard.min.js"></script>
<script src="/dist/js/scripts.js"></script>
<script src="/dist/js/custom-select.js"></script>
{include file='js/page/custom_js.tpl'}
{include file='js/page/dashboard_js.tpl'}
{include file='js/page/notification_js.tpl'}
{include file='js/page/search_js.tpl'}
</body>
</html>