<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
<meta charset="UTF-8">
<meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
<title>{$site_name} — {$site_description}</title>
<link rel="shortcut icon" href="{$site_logo}" type="image/x-icon">
<link rel="icon" href="{$site_logo}" type="image/x-icon">

<link rel="stylesheet" href="/dist/modules/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<link rel="stylesheet" href="/dist/modules/bootstrap-social/bootstrap-social.css">
<link rel="stylesheet" href="/dist/modules/datatables/datatables.min.css">
<link rel="stylesheet" href="/dist/modules/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="/dist/modules/datatables/Select-1.2.4/css/select.bootstrap4.min.css">
<link rel="stylesheet" href="/dist/modules/select2.min.css">
<link rel="stylesheet" href="/dist/modules/summernote/summernote-bs4.css">

<link rel="stylesheet" href="/dist/sweetalert2/sweetalert2.min.css">

<link rel="stylesheet" href="/dist/css-{$site_theme}/style.css">
<link rel="stylesheet" href="/dist/css-{$site_theme}/components.css">
{include file='css/custom_css.tpl'}
</head>
<body>

<div class="center" id="loading">
    <div class='building-blocks'>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
    </div>
</div>

<div class="main-wrapper">
{include file='apps/topnav.tpl'}
{include file='apps/sidenav.tpl'}

<div class="main-content">
<section class="section">
<div class="section-header">
<h1>User</h1>
<div class="section-header-breadcrumb">
<div class="breadcrumb-item">Main</div>
<div class="breadcrumb-item active">Create</div>
<div class="breadcrumb-item active">User</div>
</div>
</div>
<div class="section-error">
<div class="errors"></div>
</div>
<div class="section-body">
<div class="row">
    
<div class="col-md-6">
<div class="card card-primary">
<div class="card-header">
<h2 class="section-title">Create User [Single]</h2>
</div>
<div class="card-body">
<form class="adduser-single" method="post">
<input type="hidden" name="submitted" name="submitted" value="add_user">
<input type="hidden" name="_key" id="_key" value="{$firenet_encrypt}">
<div class="form-group">
<label for="username">Username</label>
<input id="username" type="text" class="form-control username" name="username" tabindex="1" placeholder="Enter username">
</div>
<div class="form-group">
<label for="password">Password</label>
<input id="password" type="text" class="form-control password" name="password" tabindex="1" placeholder="Enter password">
</div>
<div class="form-group">
<label for="subscription">Subscription</label>
<select class="form-control select2" id="subscription" name="subscription" data-minimum-results-for-search="-1">
    <option value="normal10" selected="">Normal (10 Days)</option>
    <option value="normal15" selected="">Normal (15 Days)</option>
    <option value="normal20" selected="">Normal (20 Days)</option>
    <option value="normal" selected="">Normal (30 Days)</option>
<option value="trial" class="trialclass">Trial</option>
</select>
</div>
<div class="form-group">
<button type="submit" class="btn btn-primary btn-adduser-single " tabindex="4">Create</button>
<button type="button" class="btn btn-info gen-user" onclick="gen_user()" tabindex="4">Regenerate</button>
</div>
</form>
</div>
</div>
</div>

<div class="col-md-6">
<div class="card card-primary">
<div class="card-header">
<h2 class="section-title">Create User [Bulk]</h2>
</div>
<div class="card-body">
<form action="" class="adduser-bulk">
    <input type="hidden" name="submitted" name="submitted" value="add_bulk">
<input type="hidden" name="_key" id="_key" value="{$firenet_encrypt}">
<div class="form-group">
<label for="credits">Credit Balance</label>
<input id="credits" type="text" value="" class="form-control credits" tabindex="1" readonly="">
</div>
<div class="form-group">
<label for="prefix">Prefix</label>
<input id="prefix" type="text" value="" class="form-control prefix" name="prefix" tabindex="1">
</div>
<div class="form-group">
<label for="amount">Amount</label>
<input id="amount" type="number" value="0" min="0" class="form-control amount" name="amount" tabindex="1" required="">
</div>
<div class="form-group">
<button type="submit" class="btn btn-primary btn-adduser-bulk" tabindex="4">
Generate
</button>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</section>
</div>

<div class="modal fade normal-modalize" role="dialog" aria-labelledby="smallmodal">
<div class="modal-dialog modal-md normal-modal-dialog" role="document">
<div class="modal-content normal-modal-content">
<div class="modal-header normal-modal-header">
<h5 class="modal-title normal-modal-title"></h5>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body normal-modal-body">
<div class="modal-error normal-modal-error"></div>
<div class="modal-html normal-modal-html"></div>
</div>
</div>
</div>
</div>

<div class="modal fade search-modalize" role="dialog" aria-labelledby="smallmodal">
<div class="modal-dialog modal-md search-modal-dialog" role="document">
<div class="modal-content search-modal-content">
<div class="modal-header search-modal-header">
<h5 class="modal-title search-modal-title"></h5>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body search-modal-body">
<div class="modal-error search-modal-error"></div>
<div class="modal-html search-modal-html"></div>
</div>
</div>
</div>
</div>

<script src="/dist/modules/jquery.min.js"></script>
<script src="/dist/modules/popper.js"></script>
<script src="/dist/modules/tooltip.js"></script>
<script src="/dist/modules/bootstrap/js/bootstrap.min.js"></script>
<script src="/dist/modules/nicescroll/jquery.nicescroll.min.js"></script>
<script src="/dist/modules/moment.min.js"></script>

<script src="/dist/sweetalert2/sweetalert2.min.js"></script>

<script src="/dist/modules/time.js"></script>
<script src="/dist/js/stisla.js"></script>

<script src="/dist/modules/chart.min.js"></script>
<script src="/dist/modules/datatables/datatables.min.js"></script>
<script src="/dist/modules/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js"></script>
<script src="/dist/modules/datatables/Select-1.2.4/js/dataTables.select.min.js"></script>
<script src="/dist/modules/jquery-ui/jquery-ui.min.js"></script>
<script src="/dist/bootstrap/assets/jqueryform/jquery.form.js"></script>
<script src="/dist/modules/summernote/summernote-bs4.min.js"></script>
<script src="/dist/modules/select2.full.min.js"></script>

<script src="/dist/js/clipboard.min.js"></script>
<script src="/dist/js/scripts.js"></script>
<script src="/dist/js/custom-select.js"></script>
{include file='js/page/custom_js.tpl'}
{include file='js/page/notification_js.tpl'}
{include file='js/page/adduser_js.tpl'}
{include file='js/page/search_js.tpl'}
</body>
</html>